/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;

public abstract class AbstractIterationOrderRetainingElementSource<T>
implements ElementSource<T> {
    private final List<Element<T>> inserted = new ArrayList<Element<T>>();
    private Action<T> realizeAction;

    List<Element<T>> getInserted() {
        return this.inserted;
    }

    @Override
    public boolean isEmpty() {
        return this.inserted.isEmpty();
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.inserted.isEmpty();
    }

    @Override
    public int size() {
        return this.inserted.size();
    }

    @Override
    public int estimatedSize() {
        return this.inserted.size();
    }

    @Override
    public boolean contains(Object element) {
        return Iterators.contains(this.iterator(), (Object)element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        for (Object e : elements) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Iterator<Element<T>> iterator = this.inserted.iterator();
        while (iterator.hasNext()) {
            Element<T> provider = iterator.next();
            if (!provider.isRealized() || !provider.getValue().equals(o)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.inserted.clear();
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
    }

    @Override
    public void realizePending() {
        for (Element<T> element : this.inserted) {
            if (element.isRealized()) continue;
            element.realize();
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        for (Element<T> element : this.inserted) {
            if (element.isRealized() || element.getType() != null && !type.isAssignableFrom(element.getType())) continue;
            element.realize();
        }
    }

    Element<T> cachingElement(ProviderInternal<? extends T> provider) {
        return new CachingElement<T>(provider, this.realizeAction);
    }

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        Iterator<Element<T>> iterator = this.inserted.iterator();
        while (iterator.hasNext()) {
            Element<? extends T> next = iterator.next();
            if (!next.caches(provider)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public void onRealize(Action<T> action) {
        this.realizeAction = action;
    }

    protected static class CachingElement<T>
    implements Element<T> {
        private final ProviderInternal<? extends T> delegate;
        private T value;
        private boolean realized;
        private final Action<T> realizeAction;
        private boolean duplicate;

        CachingElement(ProviderInternal<? extends T> delegate, Action<T> realizeAction) {
            this.delegate = delegate;
            this.realizeAction = realizeAction;
        }

        CachingElement(T value) {
            this.value = value;
            this.realized = true;
            this.realizeAction = null;
            this.delegate = null;
        }

        @Override
        public Class<? extends T> getType() {
            if (this.delegate != null) {
                return this.delegate.getType();
            }
            return null;
        }

        @Override
        public boolean isRealized() {
            return this.realized;
        }

        @Override
        public void realize() {
            if (this.value == null && this.delegate != null) {
                this.value = this.delegate.get();
                this.realized = true;
                if (this.realizeAction != null) {
                    this.realizeAction.execute(this.value);
                }
            }
        }

        @Override
        @Nullable
        public T getValue() {
            if (!this.realized) {
                this.realize();
            }
            return this.value;
        }

        @Override
        public boolean caches(ProviderInternal<? extends T> provider) {
            return Objects.equal(this.delegate, provider);
        }

        @Override
        public boolean isDuplicate() {
            return this.duplicate;
        }

        @Override
        public void setDuplicate(boolean isDuplicate) {
            this.duplicate = isDuplicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachingElement that = (CachingElement)o;
            return Objects.equal(this.delegate, that.delegate) && Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate, this.value});
        }
    }

    protected static class RealizedElementCollectionIterator<T>
    implements Iterator<T> {
        final List<Element<T>> backingList;
        final Spec<Element<T>> acceptanceSpec;
        int nextIndex = -1;
        int previousIndex = -1;
        T next;

        RealizedElementCollectionIterator(List<Element<T>> backingList, Spec<Element<T>> acceptanceSpec) {
            this.backingList = backingList;
            this.acceptanceSpec = acceptanceSpec;
            this.updateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private void updateNext() {
            int i;
            for (i = this.nextIndex + 1; i < this.backingList.size(); ++i) {
                Element<T> candidate = this.backingList.get(i);
                if (!candidate.isRealized() || !this.acceptanceSpec.isSatisfiedBy(candidate)) continue;
                T value = candidate.getValue();
                this.nextIndex = i;
                this.next = value;
                return;
            }
            this.nextIndex = i;
            this.next = null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T thisNext = this.next;
            this.previousIndex = this.nextIndex;
            this.updateNext();
            return thisNext;
        }

        @Override
        public void remove() {
            if (this.previousIndex > -1) {
                this.backingList.remove(this.previousIndex);
                this.previousIndex = -1;
                --this.nextIndex;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    protected static interface Element<T> {
        public boolean isRealized();

        public boolean caches(ProviderInternal<? extends T> var1);

        public void realize();

        public Class<? extends T> getType();

        public T getValue();

        public boolean isDuplicate();

        public void setDuplicate(boolean var1);
    }
}

