/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.File;
import java.util.Collections;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.CachingServiceLocator;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceLocator;

public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    private final CachingServiceLocator systemClassLoaderServiceLocator = CachingServiceLocator.of(new DefaultServiceLocator(ClassLoader.getSystemClassLoader()));

    @Override
    public ClassLoader getIsolatedSystemClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    @Override
    public ClassLoader createIsolatedClassLoader(ClassPath classPath) {
        if (DefaultClassLoaderFactory.needJaxpImpl()) {
            classPath = this.addToClassPath(classPath, ClasspathUtil.getClasspathForResource(ClassLoader.getSystemClassLoader(), "META-INF/services/javax.xml.parsers.SAXParserFactory"));
            classPath = this.addToClassPath(classPath, ClasspathUtil.getClasspathForClass("org.w3c.dom.ElementTraversal"));
        }
        return this.doCreateClassLoader(this.getIsolatedSystemClassLoader(), classPath);
    }

    private ClassPath addToClassPath(ClassPath classPath, File file) {
        if (file != null) {
            return classPath.plus(Collections.singletonList(file));
        }
        return classPath;
    }

    @Override
    public ClassLoader createFilteringClassLoader(ClassLoader parent, FilteringClassLoader.Spec spec) {
        FilteringClassLoader.Spec classLoaderSpec = new FilteringClassLoader.Spec(spec);
        if (DefaultClassLoaderFactory.needJaxpImpl()) {
            DefaultClassLoaderFactory.makeServiceVisible(this.systemClassLoaderServiceLocator, classLoaderSpec, SAXParserFactory.class);
            DefaultClassLoaderFactory.makeServiceVisible(this.systemClassLoaderServiceLocator, classLoaderSpec, DocumentBuilderFactory.class);
            DefaultClassLoaderFactory.makeServiceVisible(this.systemClassLoaderServiceLocator, classLoaderSpec, DatatypeFactory.class);
        }
        return this.doCreateFilteringClassLoader(parent, classLoaderSpec);
    }

    protected ClassLoader doCreateClassLoader(ClassLoader parent, ClassPath classPath) {
        return new VisitableURLClassLoader(parent, classPath);
    }

    protected ClassLoader doCreateFilteringClassLoader(ClassLoader parent, FilteringClassLoader.Spec spec) {
        return new FilteringClassLoader(parent, spec);
    }

    private static void makeServiceVisible(ServiceLocator locator, FilteringClassLoader.Spec classLoaderSpec, Class<?> serviceType) {
        classLoaderSpec.allowClass(locator.getFactory(serviceType).getImplementationClass());
        classLoaderSpec.allowResource("META-INF/services/" + serviceType.getName());
    }

    private static boolean needJaxpImpl() {
        return ClassLoader.getSystemResource("META-INF/services/javax.xml.parsers.SAXParserFactory") != null;
    }
}

