/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\rB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0096\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/script/CachingSequence;", "T", "Lkotlin/sequences/Sequence;", "from", "(Lkotlin/sequences/Sequence;)V", "cache", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sequenceIterator", "", "iterator", "CachingIterator", "psi"})
final class CachingSequence<T>
implements Sequence<T> {
    private final ReentrantReadWriteLock lock;
    private final Iterator<T> sequenceIterator;
    private final ArrayList<T> cache;

    @NotNull
    public Iterator<T> iterator() {
        return new CachingIterator();
    }

    public CachingSequence(@NotNull Sequence<? extends T> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        this.lock = new ReentrantReadWriteLock();
        this.sequenceIterator = from.iterator();
        CachingSequence cachingSequence = this;
        ArrayList arrayList = new ArrayList();
        cachingSequence.cache = arrayList;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0007\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/script/CachingSequence$CachingIterator;", "", "(Lorg/jetbrains/kotlin/script/CachingSequence;)V", "cacheCursor", "", "hasNext", "", "next", "()Ljava/lang/Object;", "psi"})
    private final class CachingIterator
    implements Iterator<T>,
    KMappedMarker {
        private int cacheCursor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            boolean bl;
            ReentrantReadWriteLock reentrantReadWriteLock = CachingSequence.this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                bl = this.cacheCursor < CachingSequence.this.cache.size() || CachingSequence.this.sequenceIterator.hasNext();
            }
            finally {
                readLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Object e;
            int n;
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = CachingSequence.this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Object e2;
                if (this.cacheCursor < CachingSequence.this.cache.size()) {
                    n = this.cacheCursor;
                    this.cacheCursor = n + 1;
                    e2 = CachingSequence.this.cache.get(n);
                } else {
                    Object e3;
                    Object it = e3 = CachingSequence.this.sequenceIterator.next();
                    CachingSequence.this.cache.add(it);
                    e2 = e3;
                }
                e = e2;
            }
            finally {
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

