/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.IOException;
import java.io.OutputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Terminal;
import net.rubygrapefruit.platform.TerminalSize;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;

public class AnsiTerminal
extends AbstractTerminal {
    private static final byte[] BOLD = "\u001b[1m".getBytes();
    private static final byte[] RESET = "\u001b[0m".getBytes();
    private static final byte[] START_OF_LINE = "\u001b[0E".getBytes();
    private static final byte[] CLEAR_TO_END_OF_LINE = "\u001b[0K".getBytes();
    private final Terminals.Output output;
    private final OutputStream outputStream;
    private Terminal.Color foreground;

    public AnsiTerminal(OutputStream outputStream2, Terminals.Output output) {
        this.outputStream = outputStream2;
        this.output = output;
    }

    public String toString() {
        return String.format("ANSI terminal on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    protected void init() {
    }

    public boolean supportsTextAttributes() {
        return true;
    }

    public boolean supportsColor() {
        return true;
    }

    public boolean supportsCursorMotion() {
        return true;
    }

    public TerminalSize getTerminalSize() throws NativeException {
        return new MutableTerminalSize();
    }

    public Terminal foreground(Terminal.Color color) throws NativeException {
        try {
            String esc = String.format("\u001b[%sm", 30 + color.ordinal());
            this.outputStream.write(esc.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not set foreground color on %s.", this.getOutputDisplay()), e);
        }
        this.foreground = color;
        return this;
    }

    public Terminal bold() throws NativeException {
        try {
            this.outputStream.write(BOLD);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not switch to bold output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal normal() throws NativeException {
        try {
            this.outputStream.write(RESET);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not switch to normal output on %s.", this.getOutputDisplay()), e);
        }
        if (this.foreground != null) {
            this.foreground(this.foreground);
        }
        return this;
    }

    public Terminal reset() throws NativeException {
        try {
            this.outputStream.write(RESET);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not reset output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal cursorLeft(int count2) throws NativeException {
        try {
            String esc = String.format("\u001b[%sD", count2);
            this.outputStream.write(esc.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal cursorRight(int count2) throws NativeException {
        try {
            String esc = String.format("\u001b[%sC", count2);
            this.outputStream.write(esc.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal cursorUp(int count2) throws NativeException {
        try {
            String esc = String.format("\u001b[%sA", count2);
            this.outputStream.write(esc.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal cursorDown(int count2) throws NativeException {
        try {
            String esc = String.format("\u001b[%sB", count2);
            this.outputStream.write(esc.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal cursorStartOfLine() throws NativeException {
        try {
            this.outputStream.write(START_OF_LINE);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    public Terminal clearToEndOfLine() throws NativeException {
        try {
            this.outputStream.write(CLEAR_TO_END_OF_LINE);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not clear to end of line on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }
}

