/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Metadata {
    @NotNull
    private final List<Directory> _directories = new ArrayList<Directory>();

    @NotNull
    public Iterable<Directory> getDirectories() {
        return this._directories;
    }

    @NotNull
    public <T extends Directory> Collection<T> getDirectoriesOfType(Class<T> type) {
        ArrayList<Directory> directories = new ArrayList<Directory>();
        for (Directory dir : this._directories) {
            if (!type.isAssignableFrom(dir.getClass())) continue;
            directories.add(dir);
        }
        return directories;
    }

    public int getDirectoryCount() {
        return this._directories.size();
    }

    public <T extends Directory> void addDirectory(@NotNull T directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory may not be null.");
        }
        this._directories.add(directory);
    }

    @Nullable
    public <T extends Directory> T getFirstDirectoryOfType(@NotNull Class<T> type) {
        for (Directory dir : this._directories) {
            if (!type.isAssignableFrom(dir.getClass())) continue;
            return (T)dir;
        }
        return null;
    }

    public boolean containsDirectoryOfType(Class<? extends Directory> type) {
        for (Directory dir : this._directories) {
            if (!type.isAssignableFrom(dir.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        for (Directory directory : this.getDirectories()) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int count = this.getDirectoryCount();
        return String.format("Metadata (%d %s)", count, count == 1 ? "directory" : "directories");
    }
}

