/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.scheduler.Pool;

public final class DataCallbackWithPool
extends MessageStream {
    private static final long serialVersionUID = 6512046150477794254L;
    private final Closure code;
    private final Pool pool;

    public DataCallbackWithPool(Pool pool, Closure code) {
        if (pool == null) {
            throw new IllegalArgumentException("Cannot create a DataCallbackWithPool without a pool parameter specified");
        }
        if (code.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("The supplied closure expects more than one argument.");
        }
        this.pool = pool;
        this.code = code;
    }

    @Override
    public MessageStream send(final Object message) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                if (DataCallbackWithPool.this.code.getMaximumNumberOfParameters() == 1) {
                    DataCallbackWithPool.this.code.call(message);
                } else {
                    DataCallbackWithPool.this.code.call();
                }
            }
        });
        return this;
    }
}

