/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.InlineClassArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.lower.VarargLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "externalVarargs", "", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "getExternalVarargs", "()Ljava/util/Set;", "setExternalVarargs", "(Ljava/util/Set;)V", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "getArgumentFromSingleSegment", "segment", "arrayInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nVarargLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1807#2,3:255\n*S KotlinDebug\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer\n*L\n125#1:255,3\n*E\n"})
final class VarargTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private Set<IrVararg> externalVarargs;

    public VarargTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.externalVarargs = new LinkedHashSet();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Set<IrVararg> getExternalVarargs() {
        return this.externalVarargs;
    }

    public final void setExternalVarargs(@NotNull Set<IrVararg> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.externalVarargs = set;
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        List currentList = new ArrayList();
        List segments2 = new ArrayList();
        InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(this.context, expression2.getVarargElementType(), expression2.getType());
        for (IrVarargElement e2 : expression2.getElements()) {
            IrVarargElement irVarargElement = e2;
            if (irVarargElement instanceof IrSpreadElement) {
                if (!((Collection)currentList).isEmpty()) {
                    segments2.add(arrayInfo.toPrimitiveArrayLiteral(currentList));
                    currentList.clear();
                }
                segments2.add(arrayInfo.unboxElementIfNeeded(((IrSpreadElement)e2).getExpression()));
                continue;
            }
            if (!(irVarargElement instanceof IrExpression)) continue;
            currentList.add(arrayInfo.unboxElementIfNeeded((IrExpression)e2));
        }
        if (!((Collection)currentList).isEmpty()) {
            segments2.add(arrayInfo.toPrimitiveArrayLiteral(currentList));
            currentList.clear();
        }
        if (segments2.isEmpty()) {
            InlineClassArrayInfo $this$visitVararg_u24lambda_u240 = arrayInfo;
            boolean bl = false;
            return $this$visitVararg_u24lambda_u240.boxArrayIfNeeded($this$visitVararg_u24lambda_u240.toPrimitiveArrayLiteral(CollectionsKt.emptyList()));
        }
        if (segments2.size() == 1) {
            IrExpression segment = (IrExpression)CollectionsKt.first(segments2);
            IrExpression argument = this.getArgumentFromSingleSegment(expression2, segment, arrayInfo);
            return arrayInfo.boxArrayIfNeeded(argument);
        }
        IrExpression arrayLiteral = VarargLoweringKt.access$toArrayLiteral(segments2, this.context, IrSimpleTypeImplKt.IrSimpleTypeImpl(this.context.getIntrinsics().getArray(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList()), this.context.getIrBuiltIns().getAnyType());
        IrSimpleFunctionSymbol concatFun = CollectionsKt.contains((Iterable)this.context.getIntrinsics().getPrimitiveArrays().keySet(), IrTypesKt.getClassifierOrNull(arrayInfo.getPrimitiveArrayType())) ? this.context.getIntrinsics().getPrimitiveArrayConcat() : this.context.getIntrinsics().getArrayConcat();
        IrCallImpl $this$visitVararg_u24lambda_u241 = irCallImpl = BuildersKt.IrCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), arrayInfo.getPrimitiveArrayType(), concatFun, 0, null, null, 96, null);
        boolean bl = false;
        $this$visitVararg_u24lambda_u241.getArguments().set(0, arrayLiteral);
        IrCallImpl res2 = irCallImpl;
        return arrayInfo.boxArrayIfNeeded(res2);
    }

    private final IrExpression getArgumentFromSingleSegment(IrVararg expression2, IrExpression segment, InlineClassArrayInfo arrayInfo) {
        IrExpression irExpression;
        Object object;
        boolean bl;
        block6: {
            if (this.externalVarargs.contains(expression2)) {
                this.externalVarargs.remove(expression2);
                return segment;
            }
            Iterable $this$any$iv = expression2.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            IrType elementType = arrayInfo.getPrimitiveElementType();
            IrSimpleFunctionSymbol copyFunction = IrTypePredicatesKt.isChar(elementType) || IrTypePredicatesKt.isBoolean(elementType) || IrTypePredicatesKt.isLong(elementType) ? this.context.getIntrinsics().getTaggedArrayCopy() : this.context.getIntrinsics().getJsArraySlice();
            Object $this$getArgumentFromSingleSegment_u24lambda_u241 = object = BuildersKt.IrCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), arrayInfo.getPrimitiveArrayType(), copyFunction, 1, null, null, 96, null);
            boolean bl3 = false;
            ((IrCallImpl)$this$getArgumentFromSingleSegment_u24lambda_u241).getTypeArguments().set(0, arrayInfo.getPrimitiveArrayType());
            ((IrMemberAccessExpression)$this$getArgumentFromSingleSegment_u24lambda_u241).getArguments().set(0, segment);
            irExpression = (IrExpression)object;
        } else {
            irExpression = segment;
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.transformChildrenVoid(expression2);
        if (((IrFunctionSymbol)expression2.getSymbol()).getOwner().isExternal()) {
            for (IrValueParameter pair : ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getParameters()) {
                if (pair.getVarargElementType() == null) continue;
                IrExpression irExpression = expression2.getArguments().get(pair);
                if ((irExpression instanceof IrVararg ? (IrVararg)irExpression : null) != null) {
                    IrVararg it;
                    it = it;
                    boolean bl = false;
                    this.externalVarargs.add(it);
                }
            }
        }
        for (Pair pair : IrUtilsKt.getAllArgumentsWithIr(expression2)) {
            InlineClassArrayInfo arrayInfo;
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrExpression argument = (IrExpression)pair.component2();
            IrType varargElementType = parameter.getVarargElementType();
            if (argument != null || varargElementType == null) continue;
            InlineClassArrayInfo $this$visitFunctionAccess_u24lambda_u241 = arrayInfo = new InlineClassArrayInfo(this.context, varargElementType, parameter.getType());
            boolean bl = false;
            IrExpression emptyArray = $this$visitFunctionAccess_u24lambda_u241.boxArrayIfNeeded($this$visitFunctionAccess_u24lambda_u241.toPrimitiveArrayLiteral(CollectionsKt.emptyList()));
            expression2.getArguments().set(parameter, emptyArray);
        }
        return expression2;
    }
}

